/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.dyeable_redstone_signal.common.block;

import com.hexagram2021.dyeable_redstone_signal.common.block.RedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.entity.CommonRedstoneWireBlockEntity;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSBlocks;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ColorfulRedstoneWireBlock
extends RedstoneWireBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private static final Vec3[][] COLORS = (Vec3[][])Util.m_137469_((Object)new Vec3[16][16], vec3ss -> {
        double b;
        double g;
        double r;
        double v;
        int i;
        for (i = 0; i <= 15; ++i) {
            v = (15.0 - (double)i) / 40.0;
            vec3ss[0][i] = new Vec3(v, v, v);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = Mth.m_14008_((double)(v * v * 0.75 - 0.5), (double)0.0, (double)1.0);
            g = 0.0;
            b = v * 0.45 + (v > 0.0 ? 0.45 : 0.35);
            vec3ss[1][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = v * 0.5 + 0.2;
            g = Math.pow(v, 1.5) * 0.35 + 0.05;
            b = 0.0;
            vec3ss[2][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = 0.0;
            g = v * 0.5 + 0.2;
            b = v * 0.5 + 0.2;
            vec3ss[3][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = ((double)i + 1.0) / 32.0;
            vec3ss[4][i] = new Vec3(v, v, v);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = 0.0;
            g = v * 0.45 + (v > 0.0 ? 0.45 : 0.35);
            b = Mth.m_14008_((double)(v * v * 0.75 - 0.5), (double)0.0, (double)1.0);
            vec3ss[5][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = Mth.m_14008_((double)(v * 0.7 - 0.2), (double)0.0, (double)1.0);
            g = v * v * 0.6 + 0.25;
            b = v * 0.65 + (v > 0.0 ? 0.35 : 0.25);
            vec3ss[6][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = ((double)i + 4.0) / 24.0;
            vec3ss[7][i] = new Vec3(v, v, v);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = Math.pow(v, 1.5) * 0.35 + 0.05;
            g = v * 0.65 + (v > 0.0 ? 0.35 : 0.25);
            b = Mth.m_14008_((double)(v * v * 0.75 - 0.5), (double)0.0, (double)1.0);
            vec3ss[8][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            r = v * 0.65 + ((v = (double)i / 15.0) > 0.0 ? 0.35 : 0.25);
            g = Mth.m_14008_((double)(v * v * 0.75 - 0.5), (double)0.0, (double)1.0);
            b = Math.pow(v, 1.5) * 0.35 + 0.05;
            vec3ss[9][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            r = v * 0.45 + ((v = (double)i / 15.0) > 0.0 ? 0.45 : 0.35);
            g = Math.pow(v, 1.5) * 0.35 + 0.05;
            b = 0.0;
            vec3ss[10][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            r = v * 0.65 + ((v = (double)i / 15.0) > 0.0 ? 0.35 : 0.25);
            g = Mth.m_14008_((double)(v * 0.7 - 0.2), (double)0.0, (double)1.0);
            b = v * v * 0.6 + 0.25;
            vec3ss[11][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = (double)i / 15.0;
            r = v * 0.5 + 0.2;
            g = 0.0;
            b = v * 0.5 + 0.2;
            vec3ss[12][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            r = v * 0.45 + ((v = (double)i / 15.0) > 0.0 ? 0.45 : 0.35);
            g = Mth.m_14008_((double)(v * v * 0.75 - 0.5), (double)0.0, (double)1.0);
            b = 0.0;
            vec3ss[13][i] = new Vec3(r, g, b);
        }
        for (i = 0; i <= 15; ++i) {
            v = ((double)i + 9.0) / 24.0;
            vec3ss[14][i] = new Vec3(v, v, v);
        }
        for (i = 0; i <= 15; ++i) {
            r = v * 0.65 + ((v = (double)i / 15.0) > 0.0 ? 0.35 : 0.25);
            g = v * 0.65 + (v > 0.0 ? 0.35 : 0.25);
            b = Mth.m_14008_((double)(v * v * 0.75 - 0.5), (double)0.0, (double)1.0);
            vec3ss[15][i] = new Vec3(r, g, b);
        }
    });
    private final String COLOR_NAME;

    public ColorfulRedstoneWireBlock(String colorName, BlockBehaviour.Properties properties) {
        super(properties);
        this.COLOR_NAME = colorName;
    }

    @Override
    public BlockState defaultBlockStateWithPower(BlockState blockState) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)((Integer)blockState.m_61143_((Property)POWER)));
    }

    @Override
    public BlockState crossStateWithPower(BlockState blockState) {
        return (BlockState)super.crossStateWithPower(blockState).m_61124_((Property)POWER, (Comparable)((Integer)blockState.m_61143_((Property)POWER)));
    }

    @Override
    protected boolean canConnectWireWith(BlockState blockState) {
        return blockState.m_60713_((Block)this) && ((ColorfulRedstoneWireBlock)blockState.m_60734_()).getColorIndex() == this.getColorIndex() || blockState.m_60713_((Block)DRSBlocks.COMMON_REDSTONE_WIRE.get());
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().m_61124_((Property)POWER, (Comparable)Integer.valueOf(0));
    }

    public int getColorIndex() {
        return CommonRedstoneWireBlockEntity.COLOR_INDEX.get(this.COLOR_NAME);
    }

    public String getColorName() {
        return this.COLOR_NAME;
    }

    @Override
    protected void updatePowerStrength(Level level, BlockPos blockPos, BlockState blockState) {
        int strength = this.calculateTargetStrength(level, blockPos);
        if (this.getPower(blockState) != strength) {
            if (level.m_8055_(blockPos) == blockState) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(strength)), 2);
            }
            level.m_46672_(blockPos, (Block)this);
            for (Direction direction : Direction.values()) {
                level.m_46672_(blockPos.m_121945_(direction), (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level level, BlockPos blockPos) {
        int i = ColorfulRedstoneWireBlock.getBestNeighborSignal(level, blockPos);
        int j = 0;
        int color = this.getColorIndex();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = blockPos.m_121945_(direction);
            BlockEntity blockEntity = level.m_7702_(blockpos);
            BlockState blockState = level.m_8055_(blockpos);
            j = Math.max(j, ColorfulRedstoneWireBlock.getWireSignal(blockEntity, blockState, color, direction));
            BlockPos blockpos1 = blockPos.m_7494_();
            if (blockState.m_60796_((BlockGetter)level, blockpos) && !level.m_8055_(blockpos1).m_60796_((BlockGetter)level, blockpos1)) {
                j = Math.max(j, ColorfulRedstoneWireBlock.getWireSignal(level.m_7702_(blockpos.m_7494_()), level.m_8055_(blockpos.m_7494_()), color, direction));
                continue;
            }
            if (blockState.m_60796_((BlockGetter)level, blockpos)) continue;
            j = Math.max(j, ColorfulRedstoneWireBlock.getWireSignal(level.m_7702_(blockpos.m_7494_()), level.m_8055_(blockpos.m_7495_()), color, direction));
        }
        return Math.max(i, j - 1);
    }

    private static int getBestNeighborSignal(Level level, BlockPos blockPos) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockPos curBlockPos = blockPos.m_121945_(direction);
            if (!level.m_8055_(curBlockPos).m_60713_((Block)DRSBlocks.COMMON_REDSTONE_CONVERTER.get())) continue;
            int j = level.m_277185_(curBlockPos, direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int getColorForPower(int colorIndex, int energy) {
        Vec3 vec3 = COLORS[colorIndex][energy];
        return Mth.m_14159_((float)((float)vec3.m_7096_()), (float)((float)vec3.m_7098_()), (float)((float)vec3.m_7094_()));
    }

    @Override
    public int getPower(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    @Override
    protected BlockState setPowerFrom(BlockState blockState, BlockState source) {
        return (BlockState)blockState.m_61124_((Property)POWER, (Comparable)((Integer)source.m_61143_((Property)POWER)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER});
    }

    @Override
    protected Vec3 getColor(int energy) {
        return COLORS[this.getColorIndex()][energy];
    }

    public int getColoredEnergy(BlockState blockState, int color) {
        return this.getColorIndex() == color ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }
}

